<?php
/**
*
* @package ppkBB3cker
* @version $Id: tcache.php 1.000 2009-02-28 17:20:00 PPK $
* @copyright (c) 2009 PPK
* http://ppkbb3cker.rx22.ru, http://protoneutron.narod.ru
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* @ignore
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

/*
* Supported constants representing bit fields are:
*/
define('CHMOD_ALL', 7);// - all permissions (7)
define('CHMOD_READ', 4);// - read permission (4)
define('CHMOD_WRITE', 2);// - write permission (2)
define('CHMOD_EXECUTE', 1);// - execute permission (1)

//'allow_attachments', 'ppkbb_tcannounce_interval', 'ppkbb_tcminannounce_interval', 'ppkbb_tcbonus_fsize', 'ppkbb_tcbonus_value', 'ppkbb_tcwait_time', 'ppkbb_tcbonus_upvalue', 'ppkbb_tccheck_fext', 'ppkbb_tcrights_tcache', 'ppkbb_tcmax_seed', 'ppkbb_tcmax_leech', 'ppkbb_tcdead_time', 'ppkbb_tccleanup_interval', 'ppkbb_tcmaxpeers_limit', 'ppkbb_tcignore_connectable', 'ppkbb_tcignored_upload', 'ppkbb_tctracker_disabled', 'ppkbb_tcclean_place', 'ppkbb_tccheck_ban', 'ppkbb_tcmaxpeers_rewrite', 'ppkbb_tcratio_start', 'ppkbb_tcmaxleech_restr', 'ppkbb_tcwait_time2', 'ppkbb_tcmaxip_pertorr', 'ppkbb_tcmaxip_pertr'

$sql = 'SELECT config_name, config_value FROM '.TRACKER_CONFIG_TABLE."";
$result = my_sql_query($sql);
while($row=mysql_fetch_row($result))
{
	$$row[0]=$row[1];
	$trcache_config[$row[0]]=$row[1];
}
mysql_free_result($result);

t_recache('config', $trcache_config);

function t_recache($fname, $data)
{
	global $tcachedir, $phpEx;

	if(!$fname || !is_writable($tcachedir))
	{
		return false;
	}

	$data['cachetime']=time();

	$fn=$tcachedir.'data_ppkBB3cker_'.$fname.'.'.$phpEx;
	$fo=@fopen($fn, 'wb');
	if($fo)
	{
		@flock($fo, LOCK_EX);
		@fwrite($fo, "<?\n\$cache_data=unserialize('".serialize($data) ."');\n?>");
		//@fflush($fo);
		@flock($fo, LOCK_UN);
		@fclose($fo);

		phpbb_chmod($fn, CHMOD_WRITE);
	}
}

//From includes/functions.php
function phpbb_chmod($filename, $perms = CHMOD_READ)
{
	// Return if the file no longer exists.
	if (!file_exists($filename))
	{
		return false;
	}

	if (!function_exists('fileowner') || !function_exists('filegroup'))
	{
		$file_uid = $file_gid = false;
		$common_php_owner = $common_php_group = false;
	}
	else
	{
		global $phpbb_root_path, $phpEx;

		// Determine owner/group of common.php file and the filename we want to change here
		$common_php_owner = fileowner($phpbb_root_path . 'common.' . $phpEx);
		$common_php_group = filegroup($phpbb_root_path . 'common.' . $phpEx);

		$file_uid = fileowner($filename);
		$file_gid = filegroup($filename);

		// Try to set the owner to the same common.php has
		if ($common_php_owner !== $file_uid && $common_php_owner !== false && $file_uid !== false)
		{
			// Will most likely not work
			if (@chown($filename, $common_php_owner));
			{
				clearstatcache();
				$file_uid = fileowner($filename);
			}
		}

		// Try to set the group to the same common.php has
		if ($common_php_group !== $file_gid && $common_php_group !== false && $file_gid !== false)
		{
			if (@chgrp($filename, $common_php_group));
			{
				clearstatcache();
				$file_gid = filegroup($filename);
			}
		}
	}

	// And the owner and the groups PHP is running under.
	$php_uid = (function_exists('posix_getuid')) ? @posix_getuid() : false;
	$php_gids = (function_exists('posix_getgroups')) ? @posix_getgroups() : false;

	// Who is PHP?
	if ($file_uid === false || $file_gid === false || $php_uid === false || $php_gids === false)
	{
		$php = NULL;
	}
	else if ($file_uid == $php_uid /* && $common_php_owner !== false && $common_php_owner === $file_uid*/)
	{
		$php = 'owner';
	}
	else if (in_array($file_gid, $php_gids))
	{
		$php = 'group';
	}
	else
	{
		$php = 'other';
	}

	// Owner always has read/write permission
	$owner = CHMOD_READ | CHMOD_WRITE;
	if (is_dir($filename))
	{
		$owner |= CHMOD_EXECUTE;

		// Only add execute bit to the permission if the dir needs to be readable
		if ($perms & CHMOD_READ)
		{
			$perms |= CHMOD_EXECUTE;
		}
	}

	switch ($php)
	{
		case null:
		case 'owner':
			/* ATTENTION: if php is owner or NULL we set it to group here. This is the most failsafe combination for the vast majority of server setups.

			$result = @chmod($filename, ($owner << 6) + (0 << 3) + (0 << 0));

			clearstatcache();

			if (!is_null($php) || (is_readable($filename) && is_writable($filename)))
			{
				break;
			}
		*/

		case 'group':
			$result = @chmod($filename, ($owner << 6) + ($perms << 3) + (0 << 0));

			clearstatcache();

			if (!is_null($php) || ((!($perms & CHMOD_READ) || is_readable($filename)) && (!($perms & CHMOD_WRITE) || is_writable($filename))))
			{
				break;
			}

		case 'other':
			$result = @chmod($filename, ($owner << 6) + ($perms << 3) + ($perms << 0));

			clearstatcache();

			if (!is_null($php) || ((!($perms & CHMOD_READ) || is_readable($filename)) && (!($perms & CHMOD_WRITE) || is_writable($filename))))
			{
				break;
			}

		default:
			return false;
		break;
	}

	return $result;
}

?>