<?php
/**
*
* acp_board [Russian]
*
* @package language
* @version $Id: board.php,v 1.101 2007/11/03 20:29:39 acydburn Exp $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'Здесь вы можете установить общие параметры конференции, дать ей имя и описание, а также указать часовой пояс и язык, которые будут использоваться по умолчанию.',
	'CUSTOM_DATEFORMAT'				=> 'Другой…',
	'DEFAULT_DATE_FORMAT'			=> 'Формат даты',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'Синтаксис идентичен функции <code>date</code> языка PHP.',
	'DEFAULT_LANGUAGE'				=> 'Язык по умолчанию',
	'DEFAULT_STYLE'					=> 'Стиль по умолчанию',
	'DISABLE_BOARD'					=> 'Отключить конференцию',
	'DISABLE_BOARD_EXPLAIN'			=> 'Конференция станет недоступной для пользователей. Также вы можете ввести короткое сообщение (до 255 символов) для посетителей.',
	'OVERRIDE_STYLE'				=> 'Заменять стиль пользователя',
	'OVERRIDE_STYLE_EXPLAIN'		=> 'Стиль, выбранный пользователем, будет заменён стилем по умолчанию.',
	'SITE_DESC'						=> 'Описание сайта',
	'SITE_NAME'						=> 'Имя сайта',
	'SYSTEM_DST'					=> 'Сейчас действует летнее время (<abbr title="Летнее время">DST</abbr>)',
	'SYSTEM_TIMEZONE'				=> 'Часовой пояс по умолчанию',
	'WARNINGS_EXPIRE'				=> 'Длительность предупреждения',
	'WARNINGS_EXPIRE_EXPLAIN'		=> 'Количество дней, которое должно пройти до того, как предупреждение будет автоматически снято с пользователя',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'Здесь вы можете включать и отключать некоторые функции конференции',

	'ALLOW_ATTACHMENTS'			=> 'Разрешить вложения',
	'ALLOW_BIRTHDAYS'			=> 'Разрешить дни рождения',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'Разрешить указывать дни рождения и отображения возраста в профиле. Учтите, что список дней рождения на странице списка форумов включается отдельно в настройках нагрузки на сервер.',
	'ALLOW_BOOKMARKS'			=> 'Разрешить закладки на темы',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'Пользователь сможет сохранять персональные закладки',
	'ALLOW_BBCODE'				=> 'Разрешить BBCode',
	'ALLOW_FORUM_NOTIFY'		=> 'Разрешить подписку на форумы',
	'ALLOW_NAME_CHANGE'			=> 'Разрешить смену имени пользователя',
	'ALLOW_NO_CENSORS'			=> 'Разрешить отключение автоцензора',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'Пользователи смогут по выбору отключать автоцензор в обычных и личных сообщениях.',
	'ALLOW_PM_ATTACHMENTS'		=> 'Разрешить вложения в личных сообщениях',
	'ALLOW_SIG'					=> 'Разрешить подписи',
	'ALLOW_SIG_BBCODE'			=> 'Разрешить BBCode в подписях пользователей',
	'ALLOW_SIG_FLASH'			=> 'Разрешить использование тега BBCode <code>[FLASH]</code> в подписях пользователей',
	'ALLOW_SIG_IMG'				=> 'Разрешить использование тега BBCode <code>[IMG]</code> в подписях пользователей',
	'ALLOW_SIG_LINKS'			=> 'Разрешить ссылки в подписях пользователей',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_SIG_SMILIES'			=> 'Разрешить смайлики в подписях пользователей',
	'ALLOW_SMILIES'				=> 'Разрешить смайлики',
	'ALLOW_TOPIC_NOTIFY'		=> 'Разрешить подписку на темы',
	'BOARD_PM'					=> 'Личные сообщения',
	'BOARD_PM_EXPLAIN'			=> 'Включение или отключение личных сообщений для всех пользователей.',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'Аватары — это небольшие индивидуальные изображения, которые пользователи могут ассоциировать со своими учётными записями. В зависимости от выбранного стиля, аватары обычно отображаются под именем пользователя при просмотре тем. Здесь вы можете настроить использование аватар пользователями. Пожалуйста, учтите, что для загрузки аватар необходимо создать папку, имя которой задаётся ниже, и удостовериться в том, что вебсервер имеет права на запись в эту папку. Учтите также, что ограничение на размер файлов накладываются только на загружаемые на сервер аватары, и не распространяются на удалённые изображения.',

	'ALLOW_LOCAL'					=> 'Разрешить галерею аватар',
	'ALLOW_REMOTE'					=> 'Разрешить удалённые аватары',
	'ALLOW_REMOTE_EXPLAIN'			=> 'Ссылки на аватары с других сайтов.',
	'ALLOW_UPLOAD'					=> 'Разрешить загрузку аватар',
	'AVATAR_GALLERY_PATH'			=> 'Путь к галерее аватар',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'Путь относительно корневой папки phpBB для предустановленных изображений, например <samp>images/avatars/gallery</samp>',
	'AVATAR_STORAGE_PATH'			=> 'Путь к аватарам',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'Путь относительно корневой папки phpBB, например  <samp>images/avatars/upload</samp>',
	'MAX_AVATAR_SIZE'				=> 'Максимальные размеры аватары',
	'MAX_AVATAR_SIZE_EXPLAIN'		=> '(ширина x высота в пикселах)',
	'MAX_FILESIZE'					=> 'Максимальный размер файла аватары',
	'MAX_FILESIZE_EXPLAIN'			=> 'Для загружаемых файлов аватар',
	'MIN_AVATAR_SIZE'				=> 'Минимальные размеры аватары',
	'MIN_AVATAR_SIZE_EXPLAIN'		=> '(ширина x высота в пикселах)',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать все настройки по умолчанию для личных сообщений (ЛС).',

	'ALLOW_BBCODE_PM'			=> 'Разрешить BBCode в ЛС',
	'ALLOW_FLASH_PM'			=> 'Разрешить тег BBCode <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'Учтите, что возможность использования flash, если она включена здесь, зависит также от установленных прав доступа.',
	'ALLOW_FORWARD_PM'			=> 'Разрешить пересылку ЛС',
	'ALLOW_IMG_PM'				=> 'Разрешить тег BBCode <code>[IMG]</code>',
	'ALLOW_MASS_PM'				=> 'Разрешить отправку ЛС нескольким пользователям или группам пользователей',
	'ALLOW_MASS_PM_EXPLAIN'		=> 'Отправку ЛС группам пользователей можно настроить на странице управления группами.',
	'ALLOW_PRINT_PM'			=> 'Разрешить печатный вид в ЛС',
	'ALLOW_QUOTE_PM'			=> 'Разрешить цитаты в ЛС',
	'ALLOW_SIG_PM'				=> 'Разрешить подписи в ЛС',
	'ALLOW_SMILIES_PM'			=> 'Разрешить смайлики в ЛС',
	'BOXES_LIMIT'				=> 'Максимальное количество ЛС в папке',
	'BOXES_LIMIT_EXPLAIN'		=> 'Пользователи не смогут сохранять больше, чем указанное количество сообщений, в каждой из папок для ЛС. Установите 0 для снятия ограничений.',
	'BOXES_MAX'					=> 'Максимальное количество папок для ЛС',
	'BOXES_MAX_EXPLAIN'			=> 'По умолчанию пользователи не смогут создавать больше указанного количества папок для ЛС.',
	'ENABLE_PM_ICONS'			=> 'Разрешить использование значков тем в ЛС',
	'FULL_FOLDER_ACTION'		=> 'Действие по умолчанию для переполненной папки',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'Действие по умолчанию, выполняемое для переполненной папки пользователя, в случае, если выбранное пользователем действие для папки неприменимо. Единственным исключением является папка «Отправленные», для которой действием по умолчанию всегда является удаление старых сообщений.',
	'HOLD_NEW_MESSAGES'			=> 'Отложить новые сообщения',
	'PM_EDIT_TIME'				=> 'Ограничить время редактирования',
	'PM_EDIT_TIME_EXPLAIN'		=> 'Ограничить время, в течение которого доступно редактирование отправленного, но ещё не полученного адресатом личного сообщения. Установите 0 для снятия ограничений.',
	'PM_MAX_RECIPIENTS'			=> 'Максимальное разрешённое число получателей ЛС',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'Максимальное разрешённое количество получателей личного сообщения. 0 означает отсутствие ограничения. Данное значение может быть установлено для каждой группы пользователей на странице управления группами.',	
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'			=> 'Здесь вы можете задать настройки по умолчанию для размещаемых сообщений.',
	'ALLOW_POST_LINKS'					=> 'Разрешить ссылки в обычных/личных сообщениях',
	'ALLOW_POST_LINKS_EXPLAIN'			=> 'В случае запрета тег BBCode <code>[URL]</code> и автоматическое преобразование текста в ссылки будут отключены.',
	'ALLOW_POST_FLASH'					=> 'Разрешить тег BBCode <code>[FLASH]</code> в сообщениях',
	'ALLOW_POST_FLASH_EXPLAIN'			=> 'Если тег BBCode <code>[FLASH]</code> запрещён, он будет отключён в сообщениях. Определить пользователей, имеющих право использовать тег BBCode <code>[FLASH]</code>, можно с помощью системы управления правами доступа.',

	'ENABLE_QUEUE_TRIGGER'			=> 'Включить очередь сообщений',
	'ENABLE_QUEUE_TRIGGER_EXPLAIN'	=> 'Сообщения зарегистрированных пользователей могут быть поставлены в очередь для одобрения, если число оставленных ими сообщений меньше указанного ниже значения. Данная настройка не связана со значением права доступа относительно одобрения тем/сообщений.',
	'QUEUE_TRIGGER_POSTS'			=> 'Максимальное количество сообщений для постановки в очередь',
	'QUEUE_TRIGGER_POSTS_EXPLAIN'	=> 'Если включено, пользователь сможет отправлять сообщения без одобрения только после того, как наберёт заданное количество сообщений на конференции. Если число оставленных пользователем сообщений на конференции меньше заданного, отправленное сообщение будет поставлено в очередь на одобрение автоматически.',

	'BUMP_INTERVAL'					=> 'Задержка поднятия темы',
	'BUMP_INTERVAL_EXPLAIN'			=> 'Количество минут, часов или дней с последнего сообщения, по прошествии которых можно поднимать тему.',
	'CHAR_LIMIT'					=> 'Максимальное количество символов в сообщении',
	'CHAR_LIMIT_EXPLAIN'			=> 'Количество символов, разрешённое в сообщении. Введите 0 для снятия ограничений.',
	'DISPLAY_LAST_EDITED'			=> 'Отображать сведения о последнем редактировании',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'Выберите для отображения информации о последнем редактировании сообщения',
	'EDIT_TIME'						=> 'Ограничить время редактирования',
	'EDIT_TIME_EXPLAIN'				=> 'Ограничить время, в течение которого доступно редактирование нового сообщения. Введите 0 для отключения этой возможности.',
	'FLOOD_INTERVAL'				=> 'Задержка флуда',
	'FLOOD_INTERVAL_EXPLAIN'		=> 'Количество секунд, которое должно пройти между двумя сообщениями пользователя. Чтобы разрешить пользователям игнорировать это ограничение, установите им соответствующие права.',
	'HOT_THRESHOLD'					=> 'Сообщений в популярной теме',
	'HOT_THRESHOLD_EXPLAIN'			=> 'Необходимое количество сообщений в теме для того, чтобы она приобрела статус популярной. Введите 0 для отключения популярных тем.',
	'MAX_POLL_OPTIONS'				=> 'Максимальное количество вариантов ответа в опросах',
	'MAX_POST_FONT_SIZE'			=> 'Максимальный размер шрифта в сообщении',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'Максимальный размер шрифта, разрешенный в сообщении. Введите 0 для снятия ограничений.',
	'MAX_POST_IMG_HEIGHT'			=> 'Максимальная высота изображения в сообщении',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'Максимальная высота изображений/flash в сообщениях. Введите 0 для снятия ограничений.',
	'MAX_POST_IMG_WIDTH'			=> 'Максимальная ширина изображения в сообщении',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'Максимальная ширина изображений/flash в сообщениях. Введите 0 для снятия ограничений.',
	'MAX_POST_URLS'					=> 'Максимальное количество ссылок в сообщении',
	'MAX_POST_URLS_EXPLAIN'			=> 'Максимальное количество ссылок в сообщении. Введите 0 для снятия ограничений.',
	'POSTING'						=> 'Размещение сообщений',
	'POSTS_PER_PAGE'				=> 'Сообщений на странице',
	'QUOTE_DEPTH_LIMIT'				=> 'Максимальное количество вложенных цитат в сообщении',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'		=> 'Максимальное количество вложенных в сообщение цитат. Введите 0 для снятия ограничений.',
	'SMILIES_LIMIT'					=> 'Максимальное количество смайликов в сообщении',
	'SMILIES_LIMIT_EXPLAIN'			=> 'Максимальное количество смайликов в сообщении. Введите 0 для снятия ограничений.',
	'TOPICS_PER_PAGE'				=> 'Тем на странице',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'Здесь вы можете задать настройки по умолчанию для подписей.',

	'MAX_SIG_FONT_SIZE'				=> 'Максимальный размер шрифта в подписи',
	'MAX_SIG_FONT_SIZE_EXPLAIN'		=> 'Максимальный размер шрифта, разрешённый в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_IMG_HEIGHT'			=> 'Максимальная высота изображения в подписи',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'Максимальная высота изображения/flash в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_IMG_WIDTH'				=> 'Максимальная ширина изображения в подписи',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'		=> 'Максимальная ширина изображения/flash в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_LENGTH'				=> 'Максимальная длина подписи',
	'MAX_SIG_LENGTH_EXPLAIN'		=> 'Максимальное количество символов в подписях пользователей.',
	'MAX_SIG_SMILIES'				=> 'Максимум смайликов в подписи',
	'MAX_SIG_SMILIES_EXPLAIN'		=> 'Максимальное количество смайликов, разрешённое в подписях пользователей. Введите 0 для снятия ограничений.',
	'MAX_SIG_URLS'					=> 'Максимум ссылок в подписи',
	'MAX_SIG_URLS_EXPLAIN'			=> 'Максимальное количество ссылок в подписях пользователей. Введите 0 для снятия ограничений.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать настройки, связанные с регистрацией и профилями пользователей.',

	'ACC_ACTIVATION'			=> 'Активация учётной записи',
	'ACC_ACTIVATION_EXPLAIN'	=> 'Определить, должен ли пользователь получить немедленный доступ к конференции, или для этого требуется подтверждение регистрации. Вы можете также полностью отключить регистрацию новых пользователей.',
	'ACC_ADMIN'					=> 'Администратором',
	'ACC_DISABLE'				=> 'Отключено',
	'ACC_NONE'					=> 'Нет',
	'ACC_USER'					=> 'Пользователем',
//	'ACC_USER_ADMIN'			=> 'User + Admin',
	'ALLOW_EMAIL_REUSE'			=> 'Разрешить повторное использование email-адреса',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'Разные пользователи смогут регистрироваться с одинаковым email-адресом.',
	'COPPA'						=> 'COPPA',
	'COPPA_FAX'					=> 'Номер факса для COPPA',
	'COPPA_MAIL'				=> 'Почтовый адрес для COPPA',
	'COPPA_MAIL_EXPLAIN'		=> 'Почтовый адрес, на который родители должны отправлять формы регистрации COPPA',
	'ENABLE_COPPA'				=> 'Включить COPPA',
	'ENABLE_COPPA_EXPLAIN'		=> 'От пользователя потребуется подтвердить, достиг ли он возраста 13 лет или старше, для соответствия требованиям U.S. COPPA Act. Если отключено, специальные группы COPPA больше не будут отображены.',
	'MAX_CHARS'					=> 'макс.',
	'MIN_CHARS'					=> 'мин.',

	'NO_AUTH_PLUGIN'			=> 'Не найдено подходящего модуля авторизации.',
	'PASSWORD_LENGTH'			=> 'Длина пароля',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'Минимальное и максимальное количество символов в паролях.',
	'REG_LIMIT'					=> 'Попытки регистрации',
	'REG_LIMIT_EXPLAIN'			=> 'Количество попыток регистрации с кодом подтверждения, которое могут сделать пользователи в течение одной сессии.',
	'USERNAME_ALPHA_ONLY'		=> 'Только буквенно-цифровые',
	'USERNAME_ALPHA_SPACERS'	=> 'Буквенно-цифровые и разделители',
	'USERNAME_ASCII'			=> 'ASCII (без международного юникода)',
	'USERNAME_LETTER_NUM'		=> 'Любые буквы и цифры',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'Любые буквы, цифры и разделители',
	'USERNAME_CHARS'			=> 'Ограничения на символы в имени пользователя',
	'USERNAME_CHARS_ANY'		=> 'Любые символы',
	'USERNAME_CHARS_EXPLAIN'	=> 'Символы, которые могут быть использованы в именах пользователей. Разделителями считаются символы пробела, -, +, _, [ и ]',
	'USERNAME_LENGTH'			=> 'Длина имени пользователя',
	'USERNAME_LENGTH_EXPLAIN'	=> 'Минимальное и максимальное количество символов в именах пользователей.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать настройки по умолчанию для визуального подтверждения регистрации и CAPTCHA.',

	'CAPTCHA_GD'							=> 'GD CAPTCHA',
	'CAPTCHA_GD_FOREGROUND_NOISE'			=> 'GD CAPTCHA с шумом на переднем плане',
	'CAPTCHA_GD_EXPLAIN'					=> 'Использовать библиотеку GD для создания усовершенствованной CAPTCHA.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'Использовать шум для создания усложнённой CAPTCHA.',
	'CAPTCHA_GD_X_GRID'						=> 'Фоновой шум CAPTCHA по оси X',
	'CAPTCHA_GD_X_GRID_EXPLAIN'				=> 'Используйте меньшее значение для создания более сложной CAPTCHA. Введите 0 для отключения создания шума по оси X.',
	'CAPTCHA_GD_Y_GRID'						=> 'Фоновой шум CAPTCHA по оси Y',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'				=> 'Используйте меньшее значение для создания более сложной CAPTCHA. Введите 0 для отключения создания шума по оси Y.',

	'CAPTCHA_PREVIEW_MSG'					=> 'Это просто предварительный просмотр. Изменения в настройках визуального подтверждения ещё не сохранены.',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'Здесь показывается, как будет выглядеть код подтверждения при использовании текущих настроек. Используйте кнопку «Предварительный просмотр» для обновления картинки.',
	'VISUAL_CONFIRM_POST'					=> 'Визуальное подтверждение для гостей',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'Для предотвращения массовой отправки сообщений анонимные пользователи при размещении сообщений должны будут ввести код подтверждения, показываемый им на картинке.',
	'VISUAL_CONFIRM_REG'					=> 'Визуальное подтверждение при регистрации',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'Для предотвращения автоматических регистраций новые пользователи при регистрации должны будут ввести код подтверждения, показываемый им на картинке.',
));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'		=> 'Здесь вы можете изменить настройки cookies, отправляемые в браузеры пользователей. В большинстве случаев достаточно значений по умолчанию. Если вам всё же нужно изменить настройки, то делайте это осторожно — неверные значения могут привести к невозможности входа пользователей на конференцию.',

	'COOKIE_DOMAIN'				=> 'Домен cookie',
	'COOKIE_NAME'				=> 'Имя cookie',
	'COOKIE_PATH'				=> 'Путь cookie',
	'COOKIE_SECURE'				=> 'Безопасные cookie [ https ]',
	'COOKIE_SECURE_EXPLAIN'		=> 'Если ваш сервер работает через SSL, то включите этот параметр. В противном случае оставьте выключенным. Включение этого параметра, если сервер работает не через SSL, приведёт к ошибкам при переходах по страницам конференции и при переадресации.',
	'ONLINE_LENGTH'				=> 'Временной диапазон онлайн статистики',
	'ONLINE_LENGTH_EXPLAIN'		=> 'Количество минут, по прошествии которых неактивные пользователи перестанут быть видимыми в списке «Кто сейчас на конференции». Увеличение этого значения повышает расход ресурсов сервера на создание списка.',
	'SESSION_LENGTH'			=> 'Длительность сессии',
	'SESSION_LENGTH_EXPLAIN'	=> 'Сессия будет завершена по прошествии указанного времени в секундах.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'Здесь вы можете включать и отключать некоторые функции конференции для снижения нагрузки на сервер. Для большинства серверов нет необходимости отключать какие-либо функции. Тем не менее, на некоторых системах или коллективных хостингах может быть полезным отключение возможностей, которые вам не требуются. Вы можете также задать ограничения для нагрузки на сервер и активных сессий, при превышении которых конференция будет отключена.',

	'CUSTOM_PROFILE_FIELDS'			=> 'Дополнительные поля в профилях',
	'LIMIT_LOAD'					=> 'Ограничить нагрузку на сервер',
	'LIMIT_LOAD_EXPLAIN'			=> 'Если средняя ежеминутная нагрузка на сервер превышает заданное значение, конференция будет автоматически отключена. Значение, равное 1.0, означает ~100% использование ресурсов одного процессора. Эта возможность применима только для серверов на основе UNIX. Значение будет сброшено в 0, если phpBB не сможет получить предел загрузки системы.',
	'LIMIT_SESSIONS'				=> 'Ограничить сессии',
	'LIMIT_SESSIONS_EXPLAIN'		=> 'Если количество сессий превышает заданное значение в течение одной минуты, конференция будет автоматически отключена. Введите 0 для снятия ограничений.',
	'LOAD_CPF_MEMBERLIST'			=> 'Разрешить отображение дополнительных полей профиля в списке пользователей',
	'LOAD_CPF_VIEWPROFILE'			=> 'Показывать дополнительные поля в профилях пользователей',
	'LOAD_CPF_VIEWTOPIC'			=> 'Показывать дополнительные поля профиля при просмотре тем',
	'LOAD_USER_ACTIVITY'			=> 'Показать активность пользователя',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'Отображение темы/форума, в которых пользователь наиболее активен, в его профиле и личном разделе. Рекомендуется отключить эту функцию на конференциях с более чем одним миллионом сообщений.',
	'RECOMPILE_STYLES'				=> 'Перекомпилировать старые шаблоны',
	'RECOMPILE_STYLES_EXPLAIN'		=> 'Проверять обновление файлов шаблонов на сервере и перекомпилировать их.',
	'YES_ANON_READ_MARKING'			=> 'Включить маркировку тем для гостей',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'Сохранять информацию о статусе «прочитано/не прочитано» для гостей. Если отключено, сообщения для гостей всегда помечены как прочитанные.',
	'YES_BIRTHDAYS'					=> 'Включить список дней рождения',
	'YES_BIRTHDAYS_EXPLAIN'			=> 'Если список дней рождения отключен, он не будет отображаться. Для того, чтобы эта настройка работала, должна быть также включена функция дней рождения.',
	'YES_JUMPBOX'					=> 'Включить отображение быстрого перехода',
	'YES_MODERATORS'				=> 'Включить отображение модераторов',
	'YES_ONLINE'					=> 'Включить информацию об активных пользователях',
	'YES_ONLINE_EXPLAIN'			=> 'Отображать информацию об активных пользователях на главной странице, при просмотре форумов и тем.',
	'YES_ONLINE_GUESTS'				=> 'Включить отображение гостей в списках активных пользователей',
	'YES_ONLINE_GUESTS_EXPLAIN'		=> 'Разрешить отображение информации о гостях при просмотре «Кто сейчас на конференции».',
	'YES_ONLINE_TRACK'				=> 'Включить отображение информации о пользователе «в сети/не в сети»',
	'YES_ONLINE_TRACK_EXPLAIN'		=> 'Отображать информацию о нахождении пользователя в сети в профилях и при просмотре тем.',
	'YES_POST_MARKING'				=> 'Включить свои темы',
	'YES_POST_MARKING_EXPLAIN'		=> 'Указывать, оставлял ли пользователь сообщения в теме.',
	'YES_READ_MARKING'				=> 'Включить маркировку тем на сервере',
	'YES_READ_MARKING_EXPLAIN'		=> 'Сохранять информацию о статусе «прочитано/не прочитано» в базе данных, а не в cookies.',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB поддерживает расширения аутентификации, или модули. Они позволяют вам установить способ аутентификации пользователей при их входе на конференцию. По умолчанию доступны три модуля: DB, LDAP и Apache. Не все методы требуют дополнительной информации, поэтому заполняйте только те поля, которые необходимы для выбранного метода.',

	'AUTH_METHOD'				=> 'Выбрать метод аутентификации',

	'APACHE_SETUP_BEFORE_USE'	=> 'Необходимо настроить аутентификацию apache при переключении phpBB на этот метод. Помните, что имя пользователя для аутентификации в apache должно совпадать с вашим именем пользователя в phpBB. Аутентификация apache может использоваться только с mod_php (не с версией CGI) и с отключённым safe_mode.',

	'LDAP_DN'						=> 'Основное имя LDAP [ <var>dn</var> ]',
	'LDAP_DN_EXPLAIN'				=> 'Уникальное имя (Distinguished Name), определяющее информацию о пользователе, например <samp>o=My Company,c=US</samp>',
	'LDAP_EMAIL'					=> 'Email-атрибут LDAP',
	'LDAP_EMAIL_EXPLAIN'			=> 'Задайте имя атрибута email пользователя (если он существует), для автоматического присвоения email-адресов новым пользователям. Если это поле оставить пустым, то email-адреса пользователей, которые впервые вошли на конференцию, также будут пустыми.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'Попытка связи с сервером LDAP с указанным именем или паролем не удалась.',
	'LDAP_NO_EMAIL'					=> 'Указанный атрибут email не существует.',
	'LDAP_NO_IDENTITY'				=> 'Не удалось найти идентификатор входа в систему для %s.',
	'LDAP_PASSWORD'					=> 'Пароль LDAP',
	'LDAP_PASSWORD_EXPLAIN'			=> 'Оставьте поле пустым для использования анонимного соединения. В противном случае введите пароль для вышеуказанного пользователя. Требуется для серверов Active Directory. <strong>Внимание:</strong> этот пароль будет сохранён в базе данных в незашифрованном виде, и будет виден всем, кто имеет доступ к ней или к этой странице настроек.',
	'LDAP_PORT'						=> 'Порт сервера LDAP',
	'LDAP_PORT_EXPLAIN'				=> 'Вы можете указать порт, который должен использоваться для соединения с сервером LDAP вместо порта по умолчанию 389.',
	'LDAP_SERVER'					=> 'Имя сервера LDAP',
	'LDAP_SERVER_EXPLAIN'			=> 'Если используется LDAP, укажите хост или IP-адрес сервера LDAP. Кроме этого, вы можете указать ссылку. Например, ldap://hostname:port/',
	'LDAP_UID'						=> 'Идентификационный номер LDAP [ <var>uid</var> ]',
	'LDAP_UID_EXPLAIN'				=> 'Это ключ, с помощью которого производится поиск заданного идентификатора входа в систему. Например, <var>uid</var>, <var>sn</var>, и т.п.',
	'LDAP_USER'						=> 'Пользователь LDAP [ <var>dn</var> ]',
	'LDAP_USER_EXPLAIN'				=> 'Оставьте поле пустым для использования анонимного соединения. Если поле заполнено, phpBB использует указанное имя при соединении с сервером LDAP для поиска правильного пользователя. Например, <samp>uid=Username,ou=MyUnit,o=MyCompany,c=US</samp>. Требуется для серверов Active Directory.',
	'LDAP_USER_FILTER'				=> 'Фильтр имени пользователя LDAP',
	'LDAP_USER_FILTER_EXPLAIN'		=> 'В дальнейшем вы можете ограничить диапазон искомых объектов с помощью дополнительных фильтров. Например, результатом <samp>objectClass=posixGroup</samp> будет <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp>',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'Здесь задаются настройки, связанные с сервером и доменом. Удостоверьтесь в точности указанных вами данных, ошибки приведут к рассылке email-сообщений, содержащих неверную информацию. Задавая имя домена, помните, что оно должно включать  http:// или префикс другого протокола. Изменяйте номер порта только в случае, если вам точно известно, что сервер использует другое значение, порт 80 подходит в большинстве случаев.',

	'ENABLE_GZIP'				=> 'Включить сжатие GZip',
	'ENABLE_GZIP_EXPLAIN'		=> 'Генерируемое содержимое будет сжиматься с помощью GZip перед отправкой пользователю. Включение этой опции помогает уменьшить расход сетевого трафика, но в то же время увеличивает использование центрального процессора, как на стороне клиента, так и на сервере.',
	'FORCE_SERVER_VARS'			=> 'Принудительные настройки URL сервера',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'Если выбрано, то указанные здесь настройки будут использованы вместо автоматически определённых значений',
	'ICONS_PATH'				=> 'Путь к значкам сообщений',
	'ICONS_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/icons</samp>.',
	'PATH_SETTINGS'				=> 'Параметры путей',
	'RANKS_PATH'				=> 'Путь к картинкам званий',
	'RANKS_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/ranks</samp>.',
	'SCRIPT_PATH'				=> 'Путь к конференции',
	'SCRIPT_PATH_EXPLAIN'		=> 'Путь к папке, содержащей phpBB, относительно имени домена. Например, <samp>/phpBB3</samp>.',
	'SERVER_NAME'				=> 'Имя домена',
	'SERVER_NAME_EXPLAIN'		=> 'Имя домена, на котором работает конференция (например, <samp>www.example.com</samp>)',
	'SERVER_PORT'				=> 'Порт сервера',
	'SERVER_PORT_EXPLAIN'		=> 'Порт, на котором запущен сервер, обычно это порт 80, изменяйте только в случае, если сервер использует другой порт.',
	'SERVER_PROTOCOL'			=> 'Протокол сервера',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'Используется в качестве протокола сервера, если эти настройки включены принудительно. Если не задано или не включено принудительно, протокол будет определён по настройкам безопасных cookie (<samp>http://</samp> или <samp>https://</samp>)',
	'SERVER_URL_SETTINGS'		=> 'Настройки URL сервера',
	'SMILIES_PATH'				=> 'Путь к смайликам',
	'SMILIES_PATH_EXPLAIN'		=> 'Путь относительно корневой папки phpBB. Например, <samp>images/smilies</samp>.',
	'UPLOAD_ICONS_PATH'			=> 'Путь к значкам групп расширений',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'Путь относительно корневой папки phpBB. Например, <samp>images/upload_icons</samp>.',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'		=> 'Здесь вы можете задать установки, связанные с сессией и входом на конференцию.',

	'ALL'							=> 'Полная',
	'ALLOW_AUTOLOGIN'				=> 'Разрешить автоматический вход на конференцию',
	'ALLOW_AUTOLOGIN_EXPLAIN'		=> 'Опция определяет, могут ли пользователи автоматически входить на конференцию при её очередном посещении.',
	'AUTOLOGIN_LENGTH'				=> 'Время действия автоматического входа (дней)',
	'AUTOLOGIN_LENGTH_EXPLAIN'		=> 'Количество дней, в течение которого пользователь может автоматически входить на конференцию. Введите 0 для снятия ограничений.',
	'BROWSER_VALID'					=> 'Проверка браузера',
	'BROWSER_VALID_EXPLAIN'			=> 'Включает проверку браузера при каждой сессии для повышения безопасности.',
	'CHECK_DNSBL'					=> 'Проверить IP-адрес по чёрному списку DNS (DNS Blackhole List)',
	'CHECK_DNSBL_EXPLAIN'			=> 'Если включено, IP-адрес пользователя будет проверен с помощью следующих служб  DNSBL при регистрации или отправке сообщений: <a href="http://spamcop.net">spamcop.net</a> и <a href="http://www.spamhaus.org">www.spamhaus.org</a>. Эта процедура может занять некоторое время, в зависимости от конфигурации сервера. В случае замедления работы сервера или большого количества ложных срабатываний рекомендуется отключить эту проверку.',
	'CLASS_B'						=> 'A.B',
	'CLASS_C'						=> 'A.B.C',
	'EMAIL_CHECK_MX'				=> 'Проверить правильность почтовой записи в DNS (MX Record) домена email-адреса',
	'EMAIL_CHECK_MX_EXPLAIN'		=> 'Если включено, домен email-адреса, указанный при регистрации или изменении профиля, проверяется на правильность  почтовой записи в DNS (MX Record).',
	'FORCE_PASS_CHANGE'				=> 'Принудительная смена пароля',
	'FORCE_PASS_CHANGE_EXPLAIN'		=> 'Пользователь должен будет сменить свой пароль по прошествии указанного количества дней. Введите 0 для отключения этой функции.',
	'FORM_TIME_MAX'					=> 'Максимальное время для отправки формы',
	'FORM_TIME_MAX_EXPLAIN'			=> 'Время, за которое пользователь должен отправить форму. Установите -1 для отключения этой функции. Учтите, что форма может устареть по истечении сессии, независимо от данной настройки.',

	'FORM_SID_GUESTS'				=> 'Привязать формы к гостевым сессиям',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'Если включено, формы, отправляемые гостями, будут привязаны к конкретным сессиям. Это может вызвать проблемы с некоторыми Интернет-провайдерами.',
	'FORWARDED_FOR_VALID'			=> 'Проверка заголовка <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'Сессия будет продолжена только в том случае, если отправленный заголовок <var>X_FORWARDED_FOR</var> соответствует отправленному в предыдущем запросе. Блокировка доступа по IP-адресу будет осуществляться по IP-адресам из заголовка <var>X_FORWARDED_FOR</var>.',
	'IP_VALID'						=> 'Проверка IP-адреса сессии',
	'IP_VALID_EXPLAIN'				=> 'Определяет, какая часть IP-адреса пользователя используется для проверки сессии. <samp>Полная</samp> означает проверку всего адреса, <samp>A.B.C</samp> — первых трёх чисел (x.x.x), <samp>A.B</samp> — первых двух чисел (x.x), <samp>Нет</samp> отключает проверку. В адресах IPv6 <samp>A.B.C</samp> сравнивает первые 4 блока и <samp>A.B</samp> — первые 3 блока.',
	'MAX_LOGIN_ATTEMPTS'			=> 'Максимальное количество попыток входа',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'После указанного количества неудачных попыток входа на конференцию пользователь должен будет дополнительно визуально подтвердить свой вход (визуальное подтверждение).',
	'NO_IP_VALIDATION'				=> 'Нет',
	'NO_REF_VALIDATION'				=> 'Нет',
	'PASSWORD_TYPE'					=> 'Сложность пароля',
	'PASSWORD_TYPE_EXPLAIN'			=> 'Определяет, насколько сложным должен быть пароль при его установке или изменении. Каждый следующий вариант ограничения включает в себя предыдущие.',
	'PASS_TYPE_ALPHA'				=> 'Должен содержать буквенно-цифровые символы',
	'PASS_TYPE_ANY'					=> 'Требования отсутствуют',
	'PASS_TYPE_CASE'				=> 'Должен содержать символы разного регистра',
	'PASS_TYPE_SYMBOL'				=> 'Должен содержать символы',
	'REF_HOST'						=> 'Проверять только имя хоста',
	'REF_PATH'						=> 'Также проверять путь',
	'REFERER_VALID'					=> 'Проверять сссылку (referer)',
	'REFERER_VALID_EXPLAIN'			=> 'Если включено, будет проверяться ссылка хост/путь при отправке форм. Это может создавать проблемы при нескольких доменных адресах и разных логинах.',	
	'TPL_ALLOW_PHP'					=> 'Разрешить php в шаблонах',
	'TPL_ALLOW_PHP_EXPLAIN'			=> 'Если эта функция включена, команды <code>PHP</code> и <code>INCLUDEPHP</code> будут распознаваться и выполняться в шаблонах.',
));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'Эта информация используется для отправки конференцией email-сообщений пользователям. Удостоверьтесь в правильности указанных email-адресов, все возвращённые или не доставленные сообщения будут, вероятно, отправлены на них. Если ваш сервер не обеспечивает использование встроенной (в PHP) службы email, вы можете отправлять сообщения напрямую с использованием SMTP. Для этого необходим адрес подходящего сервера (если нужно, спросите об этом у провайдера). Если сервер требует аутентификации (и только в этом случае), введите необходимые имя, пароль и метод аутентификации.',

	'ADMIN_EMAIL'					=> 'Обратный email-адрес',
	'ADMIN_EMAIL_EXPLAIN'			=> 'Этот адрес будет использован для возврата всех email-сообщений, как email-адрес для технических контактов. Он всегда будет использоваться в качестве адресов <samp>Return-Path</samp> и <samp>Sender</samp> в email-сообщениях.',
	'BOARD_EMAIL_FORM'				=> 'Рассылка email-сообщений через конференцию',
	'BOARD_EMAIL_FORM_EXPLAIN'		=> 'Пользователи смогут отправлять email-сообщения через конференцию вместо их обычной отправки.',
	'BOARD_HIDE_EMAILS'				=> 'Скрывать email-адреса',
	'BOARD_HIDE_EMAILS_EXPLAIN'		=> 'Эта функция полностью сохраняет в тайне email-адреса.',
	'CONTACT_EMAIL'					=> 'Контактный email-адрес',
	'CONTACT_EMAIL_EXPLAIN'			=> 'Этот адрес будет использоваться при каждой необходимости контакта, например, в случае спама, ошибок и т.п. Он всегда будет использоваться в качестве адресов <samp>From</samp> и <samp>Reply-To</samp> в email-сообщениях.',
	'EMAIL_FUNCTION_NAME'			=> 'Имя функции email',
	'EMAIL_FUNCTION_NAME_EXPLAIN'	=> 'Функция email, используемая для отправки сообщений через PHP.',
	'EMAIL_PACKAGE_SIZE'			=> 'Размер почтового пакета',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'Максимальное количество email-сообщений, отправляемых за один раз. Эта настройка применяется для внутренней очереди сообщений; установите 0 при возникновении проблем, связанных с неотправленными уведомлениями по email.',
	'EMAIL_SIG'						=> 'Подпись в email-сообщении',
	'EMAIL_SIG_EXPLAIN'				=> 'Этот текст будет добавлен во все email-сообщения, отправляемые конференцией.',
	'ENABLE_EMAIL'					=> 'Включить email-сообщения',
	'ENABLE_EMAIL_EXPLAIN'			=> 'Если выключено, отправка любых email-сообщений с конференции производиться не будет.',
	'SMTP_AUTH_METHOD'				=> 'Метод аутентификации для SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'		=> 'Используется только в случае, если заданы имя/пароль. Спросите у своего провайдера, если не уверены, какой метод аутентификации использовать.',
	'SMTP_CRAM_MD5'					=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'				=> 'DIGEST-MD5',
	'SMTP_LOGIN'					=> 'LOGIN',
	'SMTP_PASSWORD'					=> 'Пароль SMTP',
	'SMTP_PASSWORD_EXPLAIN'			=> 'Введите пароль, если SMTP требует этого.',
	'SMTP_PLAIN'					=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'			=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'						=> 'Порт сервера SMTP',
	'SMTP_PORT_EXPLAIN'				=> 'Изменяйте порт только в том случае, если вам точно известно, что сервер использует другой порт.',
	'SMTP_SERVER'					=> 'Адрес сервера SMTP',
	'SMTP_SETTINGS'					=> 'Настройки SMTP',
	'SMTP_USERNAME'					=> 'Имя пользователя SMTP',
	'SMTP_USERNAME_EXPLAIN'			=> 'Введите имя только в случае, если сервер SMTP требует этого.',
	'USE_SMTP'						=> 'Использовать SMTP для отправки email-сообщений',
	'USE_SMTP_EXPLAIN'				=> 'Выберите «Да», если хотите или должны отправлять email-сообщения через сервер вместо локальной функции mail.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'Здесь вы можете включить и настроить использование Jabber в качестве мгновенных сообщений и уведомлений с конференции. Jabber — это протокол с открытым исходным кодом, и поэтому доступен для использования всеми желающими. Некоторые серверы Jabber имеют шлюзы и протоколы передачи, позволяющие связываться с пользователями других сетей. Не все серверы предоставляют все виды протоколов передачи, а изменения в протоколах могут препятствовать правильной работе. Убедитесь в том, что вы ввели данные зарегистрированной учётной записи — phpBB будет использовать эти данные в своей работе.',

	'JAB_ENABLE'				=> 'Включить Jabber',
	'JAB_ENABLE_EXPLAIN'		=> 'Включение позволяет использовать Jabber для отправки мгновенных сообщений и уведомлений',
	'JAB_GTALK_NOTE'			=> 'GTalk не будет работать, поскольку функция <samp>dns_get_record</samp> не найдена. Данная функция недоступна в PHP4 и не реализована на платформах Windows. В настоящее время функция также не работает на системах BSD, включая Mac OS.',
	'JAB_PACKAGE_SIZE'			=> 'Размер пакета Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'	=> 'Количество сообщений, отправляемых в одном пакете. Если ввести 0, то сообщения будут отправляться немедленно без постановки в очередь для последующей отправки.',
	'JAB_PASSWORD'				=> 'Пароль Jabber',
	'JAB_PORT'					=> 'Порт Jabber',
	'JAB_PORT_EXPLAIN'			=> 'Оставьте пустым, если вам известно, что используется порт, отличный от 5222',
	'JAB_SERVER'				=> 'Сервер Jabber',
	'JAB_SERVER_EXPLAIN'		=> 'Смотрите список серверов на %sjabber.org%s.',
	'JAB_SETTINGS_CHANGED'		=> 'Настройки Jabber успешно изменены.',
	'JAB_USE_SSL'				=> 'Использовать SSL для соединения',
	'JAB_USE_SSL_EXPLAIN'		=> 'Если включено, будет произведена попытка установить безопасное соединение. Порт Jabber будет изменён на 5223, если ранее был указан порт 5222.',
	'JAB_USERNAME'				=> 'Имя пользователя или JID (идентификатор) Jabber',
	'JAB_USERNAME_EXPLAIN'		=> 'Введите имя или существующий JID (идентификатор) зарегистрированного пользователя. Проверка имени производиться не будет. Если указано только имя, то ваш JID (идентификатор) будет составлен из этого имени и указанного выше имени сервера. В противном случае, укажите существующий JID (идентификатор), например user@jabber.org.',
));

// Chat settings
$lang = array_merge($lang, array(
	'ACP_CHAT_SETTINGS_EXPLAIN'			=> '',	
	
	'CHAT_WAITTIME'				=> 'Задержка отправки сообщений',
	'CHAT_WAITTIME_EXPLAIN'				=> 'После отправки сообщения кнопка отправки сообщения блокируется на указанное время (сек.)',
	'CHAT_INACTIVE_TIME'				=> 'Время неактивности',
	'CHAT_INACTIVE_TIME_EXPLAIN'				=> 'Время через которое пользователь будет считаться покинувшим чат (сек.)',	
	'CHAT_MESSLENGTH'				=> 'Длина сообщения в чате',
	'CHAT_MESSLENGTH_EXPLAIN'				=> 'Сообщения длиннее этого значения будут обрезаться (не более 255)',	
	'CHAT_MESSREFRESH'				=> 'Обновление окна сообщений',
	'CHAT_MESSREFRESH_EXPLAIN'				=> 'Время обновления окна сообщений чата (сек.)',	
	'CHAT_USERREFRESH'				=> 'Обновление окна пользователей',
	'CHAT_USERREFRESH_EXPLAIN'				=> 'Время обновления окна списка пользователей чата (сек.)',	
	'CHAT_MUREFRESH'				=> 'Обновление окна чата',
	'CHAT_MUREFRESH_EXPLAIN'				=> 'Время обновления окна списка сообщений и пользователей чата (сек.)',	
	'CHAT_MESSDISPLAY'				=> 'Количество сообщений в чате',
	'CHAT_MESSDISPLAY_EXPLAIN'				=> 'Отображать это количество последних сообщений в чате',
	'CHAT_CLEANUP_INTERVAL'				=> 'Очистка старых сообщений',
	'CHAT_CLEANUP_INTERVAL_EXPLAIN'				=> 'Периодичность удаления старых сообщений из чата (сек.)',		
	'CHAT_KILLTIME'				=> 'Выброс неактивных пользователей',
	'CHAT_KILLTIME_EXPLAIN'				=> 'Выбрасывать из чата пользователей не активных в течении этого времени (сек.)',
	'CHAT_MARCHIVE'				=> 'Архив сообщений',
	'CHAT_MARCHIVE_EXPLAIN'				=> 'Всегда держать в чате это количество сообщений чата в качестве архива (<span style="color:#FF0000;">не реализовано</span>)',		
	'CHAT_MAXSMILES'				=> 'Максимальное количество смайликов',
	'CHAT_MAXSMILES_EXPLAIN'				=> 'Максимальное количество смайликов в одном сообщении чата (для отключения ограничения поставить - 0)',	
	'CHAT_UKILL'			=> 'Выбросить всех пользователей из чата',
	'CHAT_UKILL_EXPLAIN'			=> 'Может быть нужно при массовом изменениии прав доступа в чат(ы) или понижении в правах на чат каких либо пользователей',	
	'CHAT_TIMECORRECT'				=> 'Коррекция времени в чате',
	'CHAT_TIMECORRECT_EXPLAIN'				=> 'Корректировать время в чате на указанное значение, для коррекции в меньшую сторону поставить перед значением знак минус (сек.)',	
));

// Tracker settings
$lang = array_merge($lang, array(
	'ACP_TRACKER_SETTINGS_EXPLAIN'			=> '',

	'TRACKER_BONUS_FSIZE'	=> 'Размер файла для бонуса',
	'TRACKER_BONUS_FSIZE_EXPLAIN'	=> 'За каждое нижеуказанное значение аплоада каждого торрента будет начисляться вышеуказанное значение бонуса, только на торренты размером более указанного здесь (в мегабайтах)',
	'TRACKER_DEAD_TIME'				=> 'Время жизни информации о сидерах и личерах (сек.)',
	'TRACKER_DEAD_TIME_EXPLAIN'				=> 'Данные сидеров и личеров старее этого значения будут удаляться',
	'TRACKER_CLEANUP_INTERVAL'						=> 'Время обновления информации о торрентах (сек.)',
	'TRACKER_CLEANUP_INTERVAL_EXPLAIN'						=> 'Через указанный промежуток времени будет проводиться чистка "мёртвых" сидеров и личеров, данное значение должно быть <b>больше</b> значения <u>Интервала обращений к трекеру</u> и больше значения <u>Время жизни информации о сидерах и личерах</u>',
	'TRACKER_BONUS_VALUE'					=> 'Значение бонуса за сидирование (не меньше 0.001)',
	'TRACKER_BONUS_VALUE_EXPLAIN'					=> 'Значение бонуса прибавляется к ратио',
	'TRACKER_RIGHTS_TCACHE'					=> 'Кэширование прав доступа',
	'TRACKER_RIGHTS_TCACHE_EXPLAIN'					=> 'Кэшировать права доступа на трекере на указанное время (сек.), кэширование уменьшает "время выполнения" announce.php',	
	'TRACKER_BONUS_UPVALUE'					=> 'Значение аплоада для начисления бонуса (Мб.)',
	'TRACKER_BONUS_UPVALUE_EXPLAIN'					=> '',	
	'TRACKER_ANNOUNCE_URL'			=> 'Аннонс URL трекера',
	'TRACKER_ANNOUNCE_URL_EXPLAIN'			=> 'Путь от имени домена (IP адреса) форума до файла announce.php (включая слэш в начале)',
	'TRACKER_ANNOUNCE_INTERVAL'			=> 'Интервал обращений к трекеру, в секундах',
	'TRACKER_ANNOUNCE_INTERVAL_EXPLAIN'			=> 'Данное значение должно быть <b>меньше</b> значения <u>Время обновления информации о торрентах</u> и меньше значения <u>Время жизни информации о сидерах и личерах</u>',
	'TRACKER_MINANNOUNCE_INTERVAL'			=> 'Минимальный интервал обращений к трекеру, в секундах',
	'TRACKER_MINANNOUNCE_INTERVAL_EXPLAIN'			=> 'Данное значение должно быть <b>меньше или равно</b> значению <u>Интервал обращений к трекеру</u>',
	'TRACKER_UNSET_TCACHE'			=> 'Сбросить кэш прав доступа',
	'TRACKER_UNSET_TCACHE_EXPLAIN'			=> 'Может быть нужно при массовом изменениии прав доступа на трекер или понижении в правах на трекере каких либо пользователей',	
	'TRACKER_MAX_TORRENTS'			=> 'Максимальное количество загружаемых торрентов',
	'TRACKER_MAX_TORRENTS_EXPLAIN'			=> 'Для обычных пользователей (всегда 1 - <span style="color:#FF0000;">не реализовано</span>)',
	'TRACKER_CHECK_FEXT'			=> 'Проверять разрешение на расширение в форуме',
	'TRACKER_CHECK_FEXT_EXPLAIN'			=> 'При аннонсе проверяет является ли файл торрента разрешённым в форуме, практически не нужно, если форум является трекером - торрент файлы должны быть разрешены, если форум не является трекером - "аннонсировать" торрент файл с такого форума не получится, отключение уменьшает время выполнения announce.php',
	'TRACKER_MAX_TORRENTS2'			=> 'Максимальное количество загружаемых торрентов',
	'TRACKER_MAX_TORRENTS2_EXPLAIN'			=> 'Для привилегированной группы пользователей (всегда 1 - <span style="color:#FF0000;">не реализовано</span>)',
	'TRACKER_MAX_POSTERS'			=> 'Максимальное количество загружаемых постеров',
	'TRACKER_MAX_POSTERS_EXPLAIN'			=> 'Чтобы загруженное изображение отобразилось как постер, нужно чтобы в имени загруженнного файла было слово <b>poster</b>',
	'TRACKER_MAX_SCREENSHOTS'			=> 'Максимальное количество загружаемых скриншотов',
	'TRACKER_MAX_SCREENSHOTS_EXPLAIN'			=> '',	
	'TRACKER_MAX_SEED'			=> 'Максимальное количество торрентов для одновременной раздачи (на одного пользователя)',
	'TRACKER_MAX_SEED_EXPLAIN'			=> '',	
	'TRACKER_MAX_LEECH'			=> 'Максимальное количество торрентов для одновременного скачивания (на одного пользователя)',
	'TRACKER_MAX_LEECH_EXPLAIN'			=> '',	
			
	'TRACKER_MAX_THUMBWIDTH'			=> 'Максимальная ширина миниатюр на трекере',
	'TRACKER_MAX_THUMBWIDTH_EXPLAIN'			=> 'Ширина создаваемых миниатюр не будет превышать указанного здесь размера.',	
	'TRACKER_MIN_THUMBSIZE'			=> 'Минимальный размер файлов для миниатюр на трекере',
	'TRACKER_MIN_THUMBSIZE_EXPLAIN'			=> 'Миниатюры не будут создаваться для рисунков меньше указанного размера.',
	'TRACKER_MAX_IMGWIDTHHEIGHT'			=> 'Максимальные размеры рисунков на трекере (ширина х высота)',
	'TRACKER_MAX_IMGWIDTHHEIGHT_EXPLAIN'			=> 'Максимальные размеры загружаемых рисунков. Введите 0×0 для отключения проверки размеров.',	
	'TRACKER_ENABLE_IUACTIVATE'		=> 'Активация импортированных пользователей',	
	'TRACKER_ENABLE_IUACTIVATE_EXPLAIN'		=> 'Разрешить пользователям активировать импортированные из skytracker аккаунты, на странице входа и регистрации будет размещено соответствующее сообщение.',	
	'TRACKER_MAXPEERS_LIMIT'		=> 'Ограничение на количество возвращаемых подсоединённых клиентов',	
	'TRACKER_MAXPEERS_LIMIT_EXPLAIN'		=> 'Если клиентская программа не устанавливает ограничение на возвращаемое количество подключённых к торренту клиентов, используется это значение (0 - использовать данные программы, если не переопределено ниже)',	
					
	'TRACKER_TPRIVATE_FLAG'		=> 'Устанавливать флаг приватности',	
	'TRACKER_TPRIVATE_FLAG_EXPLAIN'		=> 'Отключает в торрентах использование DHT и обмен пирами (тем не менее некоторые программы могут "обходить" это ограничение)',	
	'TRACKER_IGNORE_CONNECTABLE'		=> 'Игнорировать проверку на соединяемость',	
	'TRACKER_IGNORE_CONNECTABLE_EXPLAIN'		=> 'Отключает проверку на возможность подключения к пиру, т.е. при аннонсе будет выдавать список всех клиентов, а не только имеющих флаг connectable=yes',
		
	'TRACKER_IGNORED_UPLOAD'		=> 'Игнорировать значение аплоада',	
	'TRACKER_IGNORED_UPLOAD_EXPLAIN'		=> 'Игнорировать аплоад если он превышает указанный здесь, рассчитывается из максимально возможного аплоада за указанный аннонс интервал (на один торрент) (в Гб., 0 - отключить)',
			
	'TRACKER_DISABLED'		=> 'Отключить трекер',	
	'TRACKER_DISABLED_EXPLAIN'		=> 'Отключает функции аннонса, scrape функции, загрузка и скачиваниие торрентов не отключается',
	'TRACKER_CLEAN_PLACE'		=> 'Очистка данных мёртвых торрентов',	
	'TRACKER_CLEAN_PLACE_EXPLAIN'		=> 'Проверять и производить очистку данных мёртвых торрентов (четыре числа через пробел)<br /> число 1 - в файле аннонса (announce.php)<br />число 2 - в файле поиска (search.php)<br />число 3 - в файле просмотра форума/списка тем (viewforum.php)<br />число 4 - в файле просмотра темы/торрента (viewtopic.php)<br />1 - включено, 0 - отключено',			
	'TRACKER_CHECK_BAN'		=> 'Проверка бана по форуму',	
	'TRACKER_CHECK_BAN_EXPLAIN'		=> 'Проверять пользователя при аннонсе на бан на форуме по имени, IP адресу, email адресу',
	'TRACKER_CLEAN_SNATCH'				=> 'Удалить данные торрентов',	
	'TRACKER_CLEAN_SNATCH_EXPLAIN'				=> 'Удаляет статистику торрентов которые были удалены и/или торренты которые были потеряны, а также списки файлов в соответствующих торрентах и данные по торрентам за которые пользователи говорили или получали "Спасибо"',	
	'TRACKER_CLEAR_PIERS'				=> 'Очистить список раздач',	
	'TRACKER_CLEAR_PIERS_EXPLAIN'				=> 'Удаляет списки всех скачиваемых и раздаваемых пользователями торрентов',	
	'TRACKER_CLEAR_PIERS_TIME'					=> 'Только "мёртвые"',
	'TRACKER_CLEAR_PIERS_ALL'					=> 'Все',	
	'TRACKER_MAXPEERS_REWRITE'	=> 'Переопределение количества возвращаемых подсоединённых клиентов',
	'TRACKER_MAXPEERS_REWRITE_EXPLAIN'	=> 'Переопределять данные клиентской программы указанным выше значением',
	'TRACKER_RATIO_START'					=> 'Начало учёта ратио',
	'TRACKER_RATIO_START_EXPLAIN'					=> 'Начинать учёт ратио после достижения этого значения скачанного, ратио в этом случае независимо от скачанного и розданного будет обозначаться как None. (Гб.)',		
	'TRACKER_MAXIP_PERTORR'					=> 'Максимальное число соединений с одного IP адреса на один торрент',
	'TRACKER_MAXIP_PERTORR_EXPLAIN'					=> '(0 - отключить)',	
	'TRACKER_MAXIP_PERTR'					=> 'Максимальное число соединений с одного IP адреса',
	'TRACKER_MAXIP_PERTR_EXPLAIN'					=> '(0 - отключить)',	
	
	'ACP_PPKBB_ADDONS'			=> 'Дополнительно',		
	'PPKBB_SUBJECT_TEXTLENGTH'	=> 'Максимальная длина поля Тема при добавлении сообщения',
	'PPKBB_SUBJECT_TEXTLENGTH_EXPLAIN'	=> 'Не более 250 символов',	
));

// Tracker restricts
$lang = array_merge($lang, array(
	'ACP_TRESTRICTS_SETTINGS_EXPLAIN'			=> 'Обработка данных в таблицах идёт сверху - вниз, ратио в единицах (до 0.001) или (если ратио пользователя имеет одно из следующих значений, ограничения так-же будут работать только если ограничение по ратио является одним из этих значений): Inf. (нет скачанного и загруженного), Seed. (есть загруженное, нет скачанного), Leech. (нет загруженного, есть скачанное), None. (если активна настройка и ратио подпадает под значение: <u>Начало учёта ратио</u> независимо от скачанного и загруженного будет отображаться это значение ратио), "аплоад" в гигабайтах (целое число), "скачано" в гигабайтах (целое число), "время" в часах (0 - запрет), "торренты" в единицах (0 - запрет)',
	
	'TRACKER_WAIT_TIME'					=> 'Время ожидания или запрет на скачивание торрента при низком ратио и/или низком значении аплоада (не более 255 символов)',
	'TRACKER_WAIT_TIME_EXPLAIN'					=> 'Таблица в формате:<br /><br />ратио|аплоад|время<br />0.001|1|72<br />0.25|5|48<br />0.5|10|24<br />0.65|30|12<br />0.8|50|6<br />0.95|70|2<br />1.0|100|1<br />значения должны располагаться от меньшего к большему<br />например: 0.65|30|12 - если ратио меньше 0.65 и аплоад меньше 30Гб время ожидания на скачивание торрента 12 часов (с даты добавления торрента)',
				
	'TRACKER_WAIT_TIME2'					=> 'Время ожидания или запрет на скачивание торрента при низком ратио и/или большом значении скачанного (не более 255 символов)',
	'TRACKER_WAIT_TIME2_EXPLAIN'					=> 'Таблица в формате:<br /><br />ратио|скачано|время<br />0.95|70|13<br />0.8|50|10<br />0.65|30|7<br />0.5|10|5<br />0.25|5|3<br />0.001|1|1<br />значения должны располагаться от большего к меньшему<br />например: 0.65|30|0 - если ратио меньше 0.65 и скачано больше 30Гб скачивание торрентов невозможно (применяется только к новым торрентам, т.е. уже скачиваемые докачать можно)',	
	'TRACKER_MAXLEECH_RESTR'					=> 'Ограничение на максимальное количество скачиваемых торрентов при низком ратио и/или большом значении скачанного (не более 255 символов)',
	'TRACKER_MAXLEECH_RESTR_EXPLAIN'					=> 'Таблица в формате:<br /><br />ратио|скачано|торрентов<br />0.95|70|13<br />0.8|50|10<br />0.65|30|7<br />0.5|10|5<br />0.25|5|3<br />0.001|1|1<br />значения должны располагаться от большего к меньшему<br />Если ни одно из значений не подходит, будет использоваться значение из: <u>Максимальное количество торрентов для одновременного скачивания (на одного пользователя)</u><br />например: 0.8|50|10 - если ратио меньше 0.8 и скачано больше 50Гб максимальное количество торрентов для скачивания 10</u>',					
				)
	);
?>