function imgFit (img, maxW)
{
	if (typeof(img.naturalHeight) == 'undefined') {
		img.naturalHeight = img.height;
		img.naturalWidth  = img.width;
	}

	if (img.width > maxW) {
		img.height = Math.round((maxW/img.width)*img.height);
		img.width  = maxW;
		img.title  = 'Click image to view full size';
		img.style.cursor = 'move';
		return false;
	}
	else if (img.width == maxW && img.width < img.naturalWidth) {
		img.height = img.naturalHeight;
		img.width  = img.naturalWidth;
		img.title  = 'Click to fit in the browser window';
		return false;
	}
	else {
		return true;
	}
}

function initPost(context)
{
	initPostImages(context);
	initSpoilers(context);
}

function initPostImages(context)
{
	var $in_spoilers = $('div.sp-body var.postImg', context);
	$('var.postImg', context).not($in_spoilers).each(function(){
		var $v = $(this);
		var src = $v.attr('title');
		var $img = $('<img src="'+ src +'" class="'+ $v.attr('className') +'" alt="IMG" />');
		$img = fixPostImage($img);
		$img.bind('click', function(){ return imgFit(this, maxW); });

		$('#preload').append($img);
		var loading_icon = '<a href="'+ src +'" target="_blank"><img src="../images/spoiler/pic_loading.gif" alt="" border="0"/></a>';
		$v.html(loading_icon);

		if ($.browser.msie || $.browser.opera) {
			$img.one('load', function(){ imgFit(this, maxW);	});
			$v.empty().append($img);
			$v.after('<wbr>');
		}
		else
		{
			$img.one('load', function(){
				imgFit(this, maxW);
				$v.empty().append(this);
			});
		}
	});
}
function initSpoilers(context)
{
	$('div.sp-body', context).each(function(){
		var $sp_body = $(this);
		var name = this.title || '{L_HIDDEN_TEXT}';
		this.title = '';
		$('<div class="sp-head folded clickable">'+ name +'</div>').insertBefore($sp_body).click(function(e){
			if (!$sp_body.hasClass('inited')) {
				initPostImages($sp_body);
				$sp_body.prepend('<div class="clear"></div>').append('<div class="clear"></div>').addClass('inited');
			}
			if (e.shiftKey) {
				e.stopPropagation();
				e.shiftKey = false;
				var fold = $(this).hasClass('unfolded');
				$('div.sp-head', $($sp_body.parents('td')[0])).filter( function(){ return $(this).hasClass('unfolded') ? fold : !fold } ).click();
			}
			else {
				$(this).toggleClass('unfolded');
				$sp_body.slideToggle('fast');
			}
		});
	});
}
function fixPostImage ($img)
{
	var banned_image_hosts = /imagebanana|hidebehind/i;  // imageshack
	var src = $img[0].src;
	// keep4u
	if (src.match(/keep4u/i)) {
		var new_src = src.replace(/http:\/\/keep4u.ru\/imgs\/\w\/(.*)\/(.*)\.(.*)/, "http://keep4u.ru/torrents/$1/$2.$3");
		var new_url = src.replace(/http:\/\/keep4u.ru\/imgs\/\w\/(.*)\/(.*)\.(.*)/, "http://keep4u.ru/full/$1/$2/$3");
		$img.attr('src', new_src).addClass('clickable').bind('click', function(){ return !window.open(new_url); });
	}
	else if (src.match(banned_image_hosts)) {
		$img.wrap('<a href="'+ this.src +'" target="_blank"></a>').attr({ src: "../images/spoiler/tr_oops.gif", title: "Host for this image is banned!" });
	}
	return $img;
}

var maxW = screen.width - 202;

$(document).ready(function(){
	$(this).each(function(){ initPost( $(this) ) });
	
});
